def generate_preload(log):
    result = ''
    if len(log) < 2:
        return result

    for num in range(2):
        result += '{} {} '.format(30*num, str(log[num]['revision']))
        result += '{} {} '.format(30*num, str(log[num]['revision']))
    return result


def generate_scenario_by_last_revisions(last_revision, step, count, period):
    entries = []
    first_revision = last_revision - (count - 1) * step
    for index in xrange(count):
        entries.append('{} {}'.format(period * index, index * step + first_revision))
    return '\n'.join(entries)


def generate_scenario_by_autocheck(log, scale_factor=1, delay=None):
    result = generate_preload(log)

    if len(log):
        base_entry = log[0]
        base_date = base_entry['date']

    start_delay = delay or 3600
    for entry in log:
        delta = entry['date'] - base_date
        delta_seconds = int(delta.seconds * scale_factor) + start_delay
        result += '{} {} '.format(delta_seconds, str(entry['revision']))

    return result.strip()


def continue_scenario(scenario_str, trim_scenario_from):
    scenario_lst = scenario_str.strip().split()

    modified_scenario_lst = []
    for i in xrange(0, len(scenario_lst), 2):
        if int(scenario_lst[i]) > trim_scenario_from:
            modified_scenario_lst += [str(int(scenario_lst[i]) - trim_scenario_from), scenario_lst[i+1]]

    return ' '.join(modified_scenario_lst)
