library(ggplot2)
library(plyr)

tbl <- read.csv('out')
tbl$time <- as.POSIXlt(tbl$timestamp, origin='1970-01-01')

tbl$hour <- cut(tbl$time, breaks='hour')
tbl$time <- as.POSIXct(tbl$time)

stat <- ddply(tbl, .(hour, type), summarize,
              full.time=sum(task_finished - task_started) / 60 / 60
              )

stat$local_hour <- format(as.POSIXlt(stat$hour), "%H")

stat2 <- ddply(stat, .(local_hour, type), summarize,
      max.time = max(full.time),
      median.time = median(full.time)
)

type2os <- data.frame(type=c('ymake', 'distbuild', 'cmake'), 
                      os=c('linux', 'linux', 'freebsd')
)

stat2 <- merge(stat2, type2os)


gg <- ggplot(data=stat2, aes(local_hour, median.time, group=1, colour=type)) +
  geom_point() +
  stat_smooth(alpha=0.2) +
  facet_grid(type ~ .) +
  theme(legend.title=element_blank()) +
  scale_colour_brewer(palette="Set1") +
  xlab('hour of day') + 
  ylab('sandbox machines used (median)')

ggsave('sandbox_by_type.png', gg, width=20, height=20, units='cm')

stat3 <- ddply(stat2, .(local_hour, os), summarize,
               median.time = sum(median.time)
)

gg <- ggplot(data=stat3, aes(local_hour, median.time, group=1, colour=os)) +
  geom_point() +
  stat_smooth(alpha=0.2) +
  facet_grid(os~ .) +
  theme(legend.title=element_blank()) +
  scale_colour_brewer(palette="Set1") +
  xlab('hour of day') + 
  ylab('sandbox machines used (median)')

ggsave('sandbox_by_os.png', gg, width=20, height=20, units='cm')