library(ggplot2)
library(plyr)

tbl <- read.csv('out')
tbl$time <- as.POSIXlt(tbl$timestamp, origin='1970-01-01')
tbl_distbuild <- tbl[tbl$type == 'distbuild', ]
tbl_distbuild_2 <- tbl_distbuild[tbl_distbuild$build_system_used != '',]

commits_by_hour <- data.frame(table(cut(tbl_distbuild_2$time, breaks='hour')))
commits_by_hour$time <- as.POSIXct(commits_by_hour$Var1)

tbl_distbuild_2$hour <- cut(tbl_distbuild_2$time, breaks='hour')
tbl_distbuild_2$time <- as.POSIXct(tbl_distbuild_2$time)

mean_build_time <- ddply(tbl_distbuild_2, .(hour), summarize, build.time=mean(build.time))
mean_build_time$approx_adm <- 10 / (mean_build_time$build.time / 60 / 60)
mean_build_time$time <- as.POSIXct(mean_build_time$hour)

merged <- merge(x = mean_build_time, y = commits_by_hour, by = "time", all = TRUE)

merged$day <-  format(merged$time, "%Y-%m-%d")
merged$hour <- as.POSIXlt(merged$time)$hour


gg <- ggplot(data=merged) +
  stat_smooth(aes(hour, approx_adm, color='approx throughput of distbs'), alpha=0.2) +
  geom_point(aes(hour, approx_adm, color='approx throughput of distbs')) +
  geom_point(aes(hour, Freq, color='SVN commits flow per hour')) +
  stat_smooth(aes(hour, Freq, color='SVN commits flow per hour'), alpha=0.2) +
  scale_colour_brewer(palette="Set1") +
  ylab('load / throughput') +
  xlab('time') +
  scale_y_continuous(breaks=c(0, 5, 10, 15, 20, 30, 40)) +
  facet_wrap(~ day, nrow = 1) +
  theme(legend.title=element_blank())

gg

ggsave('distbs_throughput.png', gg, width=100, height=7.5, units='cm')
