import os
import sys
import json

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.projects.common import time_utils as tu
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sandboxsdk.parameters import SandboxStringParameter


def import_pylab(client_info):
    if '12.04-precise' in client_info['platform']:
        os.environ.update({'LD_PRELOAD': '/usr/lib/x86_64-linux-gnu/libstdc++.so.6', })
    return __import__('matplotlib.pyplot', globals(), locals()).pyplot


def import_boxplotter():
    boxplotter_path = os.path.realpath('boxplotter_dir')
    Arcadia.export('arcadia:/arc/trunk/arcadia/devtools/autocheck/analyze/tests_plotter', boxplotter_path)
    sys.path.append(boxplotter_path)
    return __import__('boxplotter', globals(), locals())


class TestsStatisticsTask(SandboxTask):
    type = 'AUTOCHECK_TESTS_STATISTICS'

    client_tags = ctc.Tag.LINUX_PRECISE

    environment = (PipEnvironment('matplotlib', '1.4', use_wheel=True), )

    class SendTo(SandboxStringParameter):
        name = 'send_to'
        description = 'Send report to'

    class Limit(SandboxStringParameter):
        name = 'limit'
        description = 'Limit'
        default_value = '1d'

    input_parameters = [SendTo, Limit, ]

    def on_execute(self):
        boxplots_path = self.abs_path('boxplots.png')
        data_path = self.abs_path('data.json')

        bp = import_boxplotter()
        json.dump(
            {
                str(k): v for k, v in bp.draw_last_period_revisions(
                    import_pylab(self.client_info), bp.parse_limit(self.ctx['limit']), save_to=boxplots_path,
                ).iteritems()
            }, open(data_path, 'w')
        )

        resource = self.create_resource('boxplots', resource_path=boxplots_path, resource_type=resource_types.AUTOCHECK_PLOT)
        self.create_resource('boxplots_data', resource_path=data_path, resource_type=resource_types.AUTOCHECK_PLOT_DATA)

        if self.ctx['send_to']:
            channel.sandbox.send_email(
                self.ctx['send_to'],
                '',
                "Autocheck Longest Tests: {}".format(tu.date_ymdhm()),
                '<img src="{}" height="550">'.format('https://proxy.sandbox.yandex-team.ru/{}'.format(resource.id)),
                content_type='text/html'
            )


__Task__ = TestsStatisticsTask
