# coding: utf-8

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.parameters import (
    SandboxStringParameter,
    SandboxIntegerParameter,
    ResourceSelector
)
from tempfile import NamedTemporaryFile


class YtTokenSecretName(SandboxStringParameter):
    name = 'yt_token_secret'
    description = 'YT token vault secret'
    required = True


class YtProxy(SandboxStringParameter):
    name = 'yt_proxy'
    description = 'YT proxy'
    default_value = "hahn"


class BaseName(SandboxStringParameter):
    name = 'base_name'
    description = 'Base name to update [domains|mobapps|offers]'
    required = True


class ChunkSize(SandboxIntegerParameter):
    name = 'chunk_size'
    description = 'Size of chunk to write to dynamic table'
    default_value = 50000
    required = True


class InsertErrorTimeout(SandboxIntegerParameter):
    name = 'insert_error_timeout'
    description = 'Timeout on error to insert to dynamic table'
    default_value = 10
    required = True


class InsertErrorAttempts(SandboxIntegerParameter):
    name = 'insert_error_attempts'
    description = 'Attempts to insert to dynamic table'
    default_value = 3
    required = True


class BBViewerBaseUpdateProgram(ResourceSelector):
    name = 'update_bb_viewer_bases_program'
    description = 'Binary program to update bases'
    resource_type = 'YMAKE_BINARY'


class BBViewerUpdateBases(SandboxTask):
    type = 'BB_VIEWER_UPDATE_BASES'

    input_parameters = [YtTokenSecretName, BBViewerBaseUpdateProgram, YtProxy, BaseName, ChunkSize, InsertErrorTimeout, InsertErrorAttempts]

    def on_execute(self):
        yt_token_secret_name = self.ctx[YtTokenSecretName.name]
        yt_proxy = self.ctx[YtProxy.name]
        base_name = self.ctx[BaseName.name]
        chunk_size = self.ctx[ChunkSize.name]
        insert_error_timeout = self.ctx[InsertErrorTimeout.name]
        insert_error_attempts = self.ctx[InsertErrorAttempts.name]
        base_update_program_resource_id = self.ctx[BBViewerBaseUpdateProgram.name]

        yt_token = self.get_vault_data(self.owner, yt_token_secret_name)
        assert yt_token is not None
        with NamedTemporaryFile() as yt_token_file:
            yt_token_file.write(yt_token)
            yt_token_file.flush()
            run_process(
                [
                    self.sync_resource(base_update_program_resource_id),
                    "--yt-token-file", yt_token_file.name,
                    "--yt-proxy", yt_proxy,
                    "--base", base_name,
                    "--chunk-size", str(chunk_size),
                    "--insert-error-timeout", str(insert_error_timeout),
                    "--insert-error-attempts", str(insert_error_attempts)
                ],
                log_prefix="update_bases_log"
            )


__Task__ = BBViewerUpdateBases
