# import logging
import os.path

from sandbox import sdk2
import sandbox.projects.resource_types as rt
from sandbox.common.types import task as ctt
from sandbox.sdk2.helpers import subprocess as sp


class BM_PACKAGE(sdk2.Resource):
    """One broadmatching/ya_packages"""
    sub_type = sdk2.parameters.String("package name", required=True)


# https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/MakeGeoDBDataFromRevision/__init__.py?rev=4279713&blame=true#L85
class BmBuildPackages(sdk2.Task):
    """Build broadmatching/ya_packages."""

    def on_execute(self):
        pkg_list = ['bm_lib', 'bm_dicts', 'bm_bannerland_lib']
        targets = ['rt-research/broadmatching/ya_packages/{}'.format(pkg) for pkg in pkg_list]
        targets.append('rt-research/broadmatching/test/pkg')
        arts = ['rt-research/broadmatching/ya_packages/{}=pkg'.format(pkg) for pkg in pkg_list]

        with self.memoize_stage.build:
            task_class = sdk2.Task["YA_MAKE"]
            sub_task = task_class(
                self,
                description='Build ya_packages',
                targets=';'.join(targets),
                arts=';'.join(arts),
                test=True,
                build_type='release',
            )
            self.Context.sub_task_id = sub_task.id
            sub_task.enqueue()
            raise sdk2.WaitTask(sub_task, ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, wait_all=True, timeout=3600)

        tmp_res = sdk2.Resource.find(type=rt.ARCADIA_PROJECT, task_id=self.Context.sub_task_id).first()
        tmp_data = sdk2.ResourceData(tmp_res)
        for pkg in pkg_list:
            pkg_path = os.path.join(str(tmp_data.path), 'pkg/{}/{}.tgz'.format(pkg, pkg))
            pkg_file = '{}.tgz'.format(pkg)
            sp.check_call(['cp', pkg_path, pkg_file])
            out_res = BM_PACKAGE(self, "{} package".format(pkg), pkg_file, sub_type=pkg, ttl=14)
            out_data = sdk2.ResourceData(out_res)
            out_data.ready()
