# coding: utf-8

"""
    Проверка пачки элементов на серпе по схемам и на качество
"""

import yaml

import sandbox.common.types.misc as ctm
import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskUnknownError


class ConfigPath(parameters.SandboxArcadiaUrlParameter):
    name = 'config_path'
    description = 'Path to config file'
    default_value = 'arcadia:/arc/trunk/arcadia/extsearch/wizards/schema_tests/config.json'
    required = True


class ServerString(parameters.SandboxStringParameter):
    name = 'servername'
    description = 'Serverstring (host + path) for shooting'
    default_value = 'hamster.yandex.ru/search/'
    required = True


class MetaHost(parameters.SandboxStringParameter):
    name = 'metahost'
    description = 'Metahost'
    required = False


class YtTokenName(parameters.SandboxStringParameter):
    name = 'yt_token'
    description = 'Name of YT token in the vault'
    required = False


class GenerateSchemas(parameters.SandboxBoolParameter):
    name = 'generate_schema'
    description = 'Generate schemas instead of checking'
    default_value = False


class BatchWebResultsChecker(SandboxTask):
    type = 'BATCH_WEB_RESULTS_CHECKER'
    dns = ctm.DnsType.DNS64
    client_tags = ctc.Tag.Group.LINUX

    input_parameters = [ConfigPath, ServerString, MetaHost, YtTokenName, GenerateSchemas]

    def on_execute(self):
        if not self.ctx.get('check_subtasks'):
            self.start_checks()

    def start_checks(self):
        config = yaml.load(Arcadia.cat(self.ctx[ConfigPath.name]))
        if "objects" not in config:
            raise SandboxTaskUnknownError("No objects in config!")

        check_tasks = []
        for el in config["objects"]:
            filter_type = el["filter_type"]
            filter_value = el.get("filter_value")
            if not filter_type:
                raise SandboxTaskUnknownError("Some objects in config has no filter_type!")

            descr = 'Check results for filter {}={}"'.format(filter_type, filter_value)
            task_type = 'WEB_RESULT_SCHEMA_CHECKER'
            limit = 0
            if self.ctx.get(GenerateSchemas.name):
                task_type = 'WEB_RESULT_SCHEMA_GENERATOR'
                limit = 100

            check_tasks.append(
                self.create_subtask(
                    task_type,
                    input_parameters={
                        'filter_type': filter_type,
                        'filter_value': filter_value,
                        'config_path': self.ctx[ConfigPath.name],
                        'serverstring': self.ctx[ServerString.name],
                        'metahost': self.ctx[MetaHost.name],
                        'yt_token': self.ctx[YtTokenName.name],
                        'limit': limit
                    },
                    description=descr,
                    inherit_notifications=True
                ).id
            )
        self.ctx['check_subtasks'] = check_tasks
        self.wait_all_tasks_completed(check_tasks)


__Task__ = BatchWebResultsChecker
