#!/usr/bin/env python

import config
import datetime
import time
import urllib2
from sandbox.projects.common.blender.fml_config_rpc_client import FmlConfigClient


def upload_times(current_time, value_max, value_median):
    data = '&'.join([
        'ts=' + str(current_time),
        'rd_max_commit_wait_time=' + str(value_max),
        'rd_median_commit_wait_time=' + str(value_median),
    ])
    urllib2.urlopen(config.RAZLADKI_MARKUP, data).read()


def main():
    cl = FmlConfigClient(config.FML_RPC_HOST, None)

    # Fetch current production release information
    releases = cl.get_rd_releases(True)
    rel_info = cl.get_rd_release_info(releases[0]["sandbox_task"])
    svn_branch = rel_info["svn_branch"]
    # release_time = releases[0]["release_time"] / 1000 # Not needed for now
    branch_info = cl.get_branch_info(svn_branch)

    current_time = int(time.time())
    bi = branch_info.get('next_trunk_commit_times')
    if bi is not None and bi:
        elapsed_time_max = current_time - int(bi[0])
        elapsed_time_median = current_time - int(bi[len(bi) >> 1])
    else:
        # No new commits means no waiting
        elapsed_time_max = 0
        elapsed_time_median = 0

    sec_to_hours = 1.0 / datetime.timedelta(hours=1).total_seconds()
    upload_times(current_time, elapsed_time_max * sec_to_hours, elapsed_time_median * sec_to_hours)


if __name__ == '__main__':
    main()
