import urlparse
from multiprocessing import cpu_count
from multiprocessing.pool import ThreadPool

from sandbox.projects.common.bno.mds import Mds, MdsUploadError
from sandbox.projects.common.bno.params import EnvTypeParam
from sandbox.projects.common.bno.resources import save_resource
from sandbox.projects.common.utils import sync_resource
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.parameters import ResourceSelector
from sandbox.sandboxsdk.task import SandboxTask


class UrlsResourceParam(ResourceSelector):
    name = 'urls_resource'
    description = 'Source urls'
    required = True


class BnoUploadImages(SandboxTask):
    type = 'BNO_UPLOAD_IMAGES'
    input_parameters = [EnvTypeParam, UrlsResourceParam]
    mds = Mds('snippets_images', 'orig', False)
    environment = (
        environments.PipEnvironment('requests'),
    )

    def on_execute(self):
        resource = sync_resource(self.ctx[UrlsResourceParam.name])
        items, _ = self.read_urls(resource)
        _, _ = self.upload_images(items)

    def upload_images(self, items):
        def upload(url):
            try:
                new_url = self.mds.upload(url)
            except MdsUploadError, e:
                return False, url, e.message
            return True, url, new_url

        result = ThreadPool(cpu_count() * 2).map(upload, items)
        items = dict(item[1:] for item in result if result[0])
        errors = dict(item[1:] for item in result if not result[0])
        save_resource(self, errors, 'url2img.txt.errors')
        return items, save_resource(self, items, 'url2img.txt')

    @staticmethod
    def read_urls(resource):
        with open(resource, 'r') as f:
            items = (item.strip() for item in f)
            items = (item for item in items if item)
            items = (item for item in items if urlparse.urlparse(item).scheme)
            return list(items), resource


__Task__ = BnoUploadImages
