from sandbox import sdk2
import sandbox.projects.resource_types.releasers as rr


class BOLVER_EXECUTABLE(sdk2.resource.AbstractResource):
    """
        Bolver binary
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = rr.wizard_releasers
    arcadia_build_path = 'search/priemka/bolver/daemons/simple_server/simple_server'


class BOLVER_RESPONSES_RESULT(sdk2.resource.AbstractResource):
    """
        Bolver output
    """
    any_arch = True
    responses_for_revision = sdk2.parameters.Integer('Revison number')


class BOLVER_PATTERNS(sdk2.resource.AbstractResource):
    """
        Bolver patterns dumps for tests
    """
    releasable = False
    auto_backup = True


class BOLVER_REQUESTS(sdk2.resource.AbstractResource):
    """
        Bolver requests for tests
    """
    releasable = False
    auto_backup = True


class BOLVER_RESPONSE_DIFF(sdk2.resource.AbstractResource):
    """
       Bolver diff html
    """
    releasable = False
    executable = False
    any_arch = True
