# -*- coding: utf-8 -*-

import itertools
import json
import os

from sandbox import sdk2
from sandbox.projects.Bolver import resources as br
from sandbox.projects.common.differ import printers, json_differ

import sandbox.projects.common.search.response.cgi as cgi


class CompareBolverResponses(sdk2.Task):
    """
    Compare bolver responses
    """

    def modify_response(self, response):
        arr = response.split(' ')
        if (len(arr) < 2):
            return response
        request = arr[1]
        delimiter_pos = request.find('?')
        if (delimiter_pos != -1):
            r = cgi.UrlCgiCustomizer(base_url=request[:delimiter_pos], params=request[(delimiter_pos + 1):])
            params = r.params
            params = sorted(params)
            r = cgi.UrlCgiCustomizer(base_url=request[:delimiter_pos], params=params)
            arr[1] = r.__str__()
            return " ".join(arr)
        return response

    def modify_responses(self, responses):
        return [[self.modify_response(response)] for response in responses]

    class Parameters(sdk2.Task.Parameters):
        c_responses = sdk2.parameters.Resource('C++ bolver responses', resource_type=br.BOLVER_RESPONSES_RESULT, required=True)
        java_responses = sdk2.parameters.Resource('Java bolver responses', resource_type=br.BOLVER_RESPONSES_RESULT, required=True)

    def on_enqueue(self):
        self.Context.out_resource_id = br.BOLVER_RESPONSE_DIFF(self, 'Diff output', 'diff').id

    def on_execute(self):
        c_path = str(sdk2.ResourceData(self.Parameters.c_responses).path)
        java_path = str(sdk2.ResourceData(self.Parameters.java_responses).path)
        with open(c_path) as json_data1, open(java_path) as json_data2:
            response_1 = self.modify_responses(json.load(json_data1))
            response_2 = self.modify_responses(json.load(json_data2))
        output_dir = str(sdk2.Resource[self.Context.out_resource_id].path)
        os.mkdir(output_dir)
        printer = printers.PrinterToHtml(os.path.join(os.getcwd(), output_dir), write_compact_diff=True, pair_head_template="response {obj_index}",
                                         obj_head_template="object")
        differ = json_differ.JsonDiffer(printer)
        cmp_data = itertools.izip(response_1, response_2, itertools.repeat('obj_id'))
        differ.compare_pairs(cmp_data)
        #self.ctx["diff_count"] = differ.get_diff_count()
        #self.ctx["compare_result"] = differ.get_diff_count() == 0
