# -*- coding: utf-8 -*-

import json
import requests
import time

from sandbox import sdk2
from sandbox.projects.Bolver import resources as br
import subprocess


class GetBolverResponses(sdk2.Task):
    '''
    Get bolver responses
    '''
    class Parameters(sdk2.Task.Parameters):
        regexp_file = sdk2.parameters.Resource('Bolver RegExp patterns file', resource_type=br.BOLVER_PATTERNS, required=True)
        bolver_binary = sdk2.parameters.Resource('Bolver binary', resource_type=br. BOLVER_EXECUTABLE, required=True)
        requests = sdk2.parameters.Resource('Bolver requests', resource_type=br.BOLVER_REQUESTS, required=True)

    def on_enqueue(self):
        self.Context.out_resource_id = br.BOLVER_RESPONSES_RESULT(
            self,
            'GetBolverResponses output',
            'output.txt'
        ).id

    def on_execute(self):
        bolver_binary = str(sdk2.ResourceData(self.Parameters.bolver_binary).path)
        output = str(sdk2.Resource[self.Context.out_resource_id].path)
        requests_path = str(sdk2.ResourceData(self.Parameters.requests).path)
        patterns = str(sdk2.ResourceData(self.Parameters.regexp_file).path)
        args = [bolver_binary, '-f', patterns]
        server = subprocess.Popen(args)
        time.sleep(1000)
        responses = []
        with open(requests_path, 'r') as requests_file, open(output, 'w') as output_file:
            data = requests_file.read()
            arr = data.split('#' * 10 + '\n')
            for item in arr:
                if (item == ""):
                    continue
                item += '\r\n'
                s = requests.Session()
                r = s.post('http://localhost:9001', data=item, verify=False)
                responses.append(r.text)
                s.close()
            json.dump(responses, output_file)
        server.kill()
