#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
from jinja2 import Environment, FileSystemLoader


class Alert(object):
    def __init__(self, st_token, api_url):
        self.subj = "[CT] Suspicious domains"
        self.queue = "BROWSER"
        self.assignees = "naumov-al"
        self.folowers = ["riosvk", "dmgor", "dselianin", "naumov-al"]
        self.api_url = api_url
        self.st_token = st_token
        path = os.path.abspath(__file__)
        self.env = Environment(loader=FileSystemLoader(os.path.join(os.path.dirname(path), "resources")))
        self.ticket_id = ""

    def proceed_detects(self, detects):
        tpl = self.env.get_template("TicketText.tpl")
        body = tpl.render(detects=detects)
        print(body)
        from startrek_client import Startrek
        st_client = Startrek(useragent="Sandbox cert_log_alert task", base_url=self.api_url, token=self.st_token)
        try:
            ticket = st_client.issues.create(queue=self.queue, summary=self.subj, assignee=self.assignees,
                                             description=body, followers=self.folowers, security="Yes")
            print("[+] St ticket {}".format(ticket.key))
            self.ticket_id = ticket.key
        except Exception as ex:
            print("[-] St ticket creation failed: {}".format(ex))
