#!/usr/bin/env python
# -*- coding: utf-8 -*-
import datetime
import json
import os
from monitor_client import CtMonitorClient
from util import domain_in_list


class Checker(object):
    def __init__(self, config, ticket):
        self.config = config
        self.detects = []
        self.predetects = []
        self.alexa_urls = []
        with open(os.path.join(os.path.dirname(os.path.abspath(__file__)),
                               "resources", "alexa1-10000-domains.json"), 'r') as f:
            content = f.read()
        self.alexa_urls = json.loads(content)
        with open(os.path.join(os.path.dirname(os.path.abspath(__file__)),
                               "resources", "whitelist-domains.json"), 'r') as f:
            content = f.read()
        self.domains_whitelist = json.loads(content)
        self.whitelist_date = datetime.datetime(2022, 05, 01)
        self.seen_before = set()
        self.ct_monitor_client = CtMonitorClient(config, ticket)

    # TODO: better check
    def __check1(self, entry):
        detect = dict()
        detect["name"] = "Domain from alexa top"
        hostname = entry.hostname
        if domain_in_list(hostname, self.alexa_urls) and not domain_in_list(hostname, self.domains_whitelist):
            detect["hostname"] = hostname
            detect["certs_chain"] = entry.get_chain_raw()
            self.detects.append(detect)

    def __check2(self, entry):
        detect = dict()
        detect["name"] = "Absence of SCTs"
        if len(entry.get_sct_list()) == 0:
            leaf_cert = entry.get_leaf_cert()
            not_valid_before = leaf_cert.not_valid_before
            # TODO: move whitelist logic to another class
            if not_valid_before > self.whitelist_date and not domain_in_list(entry.hostname, self.domains_whitelist):
                detect["hostname"] = entry.hostname
                detect["certs_chain"] = entry.get_chain_raw()
                self.detects.append(detect)

    def __check3(self, entry):
        detect = dict()
        detect["name"] = "Cert not found in log"
        domain = entry.hostname
        leaf_cert = entry.get_leaf_cert()
        sct_list = entry.get_sct_list()
        if len(sct_list) != 0 and not domain_in_list(entry.hostname, self.domains_whitelist):
            detect["hostname"] = domain
            detect["certs_chain"] = entry.get_chain_raw()
            detect["leaf_cert"] = leaf_cert
            self.predetects.append(detect)

    def apply_config(self):
        print("Applying config {}".format(self.config))

    def check(self, entry):
        cert_hash = entry.get_leaf_fingerprint()
        if cert_hash not in self.seen_before:
            self.seen_before.add(cert_hash)
            self.__check1(entry)
            self.__check2(entry)
            self.__check3(entry)
        return

    def parse_predetects(self):
        unique_hostnames = set()
        sorted_d = []
        for d in self.predetects:
            if d["hostname"] not in unique_hostnames and \
                    not self.ct_monitor_client.found_in_log(d["hostname"], d["leaf_cert"]):
                unique_hostnames.add(d["hostname"])
                sorted_d.append(d)
        return sorted_d

    def get_detects(self):
        # TODO: more generic comparison
        for d in self.parse_predetects():
            self.detects.append(d)
        return self.detects

    def get_seen_before(self):
        return self.seen_before
