#!/usr/bin/env python
# -*- coding: utf-8 -*-
from cert_chain import CertificateChain


class Entry(object):
    def __init__(self, row):
        self.raw = row
        self.hostname = ""
        self.certs_chain_raw = []
        self.cert_chain = []
        self.valid = False
        if "param" in row.keys():
            params = row["param"]
            if "a_host" in params.keys() and "certs" in params.keys():
                self.hostname = params["a_host"]
                self.certs_chain_raw = params["certs"]
        else:
            return
        self.valid = True
        self.cert_chain = CertificateChain(self.certs_chain_raw)

    def get_raw(self):
        return self.raw

    def is_valid(self):
        return self.valid

    def get_chain(self):
        return self.cert_chain

    def get_chain_raw(self):
        # return b64encode(self.certs_chain_raw[0])
        return self.certs_chain_raw[0]

    def get_leaf_cert(self):
        return self.cert_chain.get_leaf()

    def get_sct_list(self):
        return self.cert_chain.get_sct()

    def get_leaf_fingerprint(self):
        return self.cert_chain.get_leaf_fingerprint()
