#!/usr/bin/env python
# -*- coding: utf-8 -*-

TVM_DST_ALIAS = 'dst'


def main():
    import argparse
    import tvmauth
    parser = argparse.ArgumentParser()
    parser.add_argument('src_tvm_id', type=int)
    parser.add_argument('src_tvm_secret')
    parser.add_argument('dst_tvm_id', type=int)
    args = parser.parse_args()

    tvm_client = tvmauth.TvmClient(tvmauth.TvmApiClientSettings(
        self_tvm_id=args.src_tvm_id,
        enable_service_ticket_checking=True,
        enable_user_ticket_checking=tvmauth.BlackboxEnv.Prod,
        self_secret=args.src_tvm_secret,
        dsts={TVM_DST_ALIAS: args.dst_tvm_id},
    ))
    print(tvm_client.get_service_ticket_for(TVM_DST_ALIAS))


if __name__ == '__main__':
    main()
