#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import requests
from util import domain_in_list

URL_FMT = "https://{host}/{api_path}{domain}"


class CtMonitorClient(object):
    def __init__(self, config, ticket):
        # TODO: move to config
        self.host = "webmaster3-internal.test.yandex.net"
        self.api_path = "nca/ctlog/check/certificates?domain="
        self.service_ticket = ticket

    def _is_domain_present(self, response, domain, cert):
        if "data" not in response:
            return False
        if "parsedCertificates" not in response["data"]:
            return False
        for cert_entry in response["data"]["parsedCertificates"]:
            if domain_in_list(domain, cert_entry["domains"]):
                # TODO: check against fingerprint or serial
                if cert_entry["serialNumber"] == str(cert.serial_number):
                    return True
        return False

    def found_in_log(self, domain, cert):
        url = URL_FMT.format(host=self.host, api_path=self.api_path, domain=domain)
        r = requests.get(url=url, headers={'X-Ya-Service-Ticket': self.service_ticket}, verify=False)
        if r.status_code != 200:
            print("Received code {code} from {url} for {domain}".format(domain=domain, url=url, code=r.status_code))
        else:
            response = r.content
            response_dict = json.loads(response)
            if self._is_domain_present(response_dict, domain, cert):
                return True
        return False
