#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import os
import subprocess
import sys
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment


class CrbugAlert(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (PipEnvironment("bs4"),
                        PipEnvironment("defusedxml"),
                        PipEnvironment("sandbox-library"),
                        # check https://st.yandex-team.ru/DEVTOOLSSUPPORT-5219#5fd35214aa62c1459c71c34b for explanation
                        PipEnvironment("startrek_client", '2.5',
                                       custom_parameters=['--upgrade-strategy only-if-needed']))

    class Parameters(sdk2.Task.Parameters):
        n = sdk2.parameters.String("Number of posts to parse", required=True)
        st_api_url = sdk2.parameters.String("STARTREK base api url", required=False,
                                            default_value="https://st-api.yandex-team.ru/")

    def on_execute(self):
        st_token = sdk2.Vault.data(self.owner, "StOauthToken")
        sb_token = sdk2.Vault.data(self.owner, "SbOauthToken")
        file_path = os.path.join(os.path.abspath(os.path.dirname(__file__)), "alert.py")
        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("main")) as pl:
            return_code = subprocess.Popen([sys.executable, file_path, self.Parameters.n, self.Parameters.st_api_url,
                                            st_token, sb_token], stdout=pl.stdout, stderr=subprocess.STDOUT).wait()

            if return_code == 0:
                logging.info("Subprocess ended successfully")
            else:
                logging.error("Subprocess ended with error: %s", return_code)
                raise Exception("Subprocess failed!")
