#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
from vuln_crawl import VulnCrawl
from st_ticket import StTicket
from pr_draft import PrDraft


class StVulnAlert(object):
    def __init__(self, maxres, api, api_token, sb_token):
        self.api_url = api
        self.st_token = api_token
        self.sb_token = sb_token
        self.vuln_crawl = VulnCrawl(maxres)
        self.st_ticket = StTicket(self.api_url, self.st_token)
        self.pr_draft = PrDraft(self.sb_token)

    def create(self):
        vulns = self.vuln_crawl.get_vulns()
        if vulns:
            self.st_ticket.create_for_rel(vulns)
            ticket_id = self.st_ticket.get_created_ticket()
            if ticket_id:
                print("Creating PR draft based on {}".format(ticket_id))
                task_url = self.pr_draft.create_pr(vulns, ticket_id)
                self.st_ticket.add_comment("PR task {}".format(task_url))
        else:
            print("Vulnerabilities are not found")


if __name__ == '__main__':
    max_res = sys.argv[1]
    api_url = sys.argv[2]
    st_token = sys.argv[3]
    sb_token = sys.argv[4]

    st_alert = StVulnAlert(max_res, api_url, st_token, sb_token)
    st_alert.create()