# !/usr/bin/env python
# -*- coding: utf-8 -*-

from sandbox.common import rest
from sandbox.common.auth import OAuth

SB_API_URL = ""
SB_TASK_NAME = "BROWSER_APPLY_BACKPORT" # for debug
SB_TASK_URL = "https://sandbox.yandex-team.ru/task/{}"
OWNER = "naumov-al"


class PrDraft(object):
    def __init__(self, token):
        self.token = token

    def _severity2score(self, severity):
        severity_map = {
            'Critical': 4,
            'High': 3,
            'Medium': 2,
            'Low': 1,
            }
        if severity not in severity_map.keys():
            return 1
        return severity_map[severity]

    def _parse_vulns(self, vulns):
        chromium_commits = []
        v8_commits = []
        for version in vulns.keys():
            for bug_id in vulns[version].keys():
                bug_entry = vulns[version][bug_id]
                if self._severity2score(bug_entry['severity']) > 2 and bug_entry['commit_url'] != "":
                    # same logic for both chromium and v8
                    commit_id = bug_entry['commit_url'].split('/')[-1] 
                    if bug_entry['product'] == "chromium":
                        chromium_commits.append(commit_id)
                    if bug_entry['product'] == "v8":
                        v8_commits.append(commit_id)
        return chromium_commits, v8_commits

    def create_pr(self, vulns, ticket_id):
        self.ticket_id = ticket_id
        chromium_commits, v8_commits = self._parse_vulns(vulns)
        params = []
        params.append({'name': 'security_issue', 'value': self.ticket_id})
        params.append({'name': 'chromium_commits', 'value': chromium_commits})
        params.append({'name': 'v8_commits', 'value': v8_commits})
        client = rest.Client(base_url=SB_API_URL, auth=OAuth(self.token))
        task = client.task({'type':SB_TASK_NAME})
        task_params = task['input_parameters']
        print(task_params)
        task_id = task['id']
        task_url = SB_TASK_URL.format(task_id)
        print(task_url)
        print('task fields ', params)
        client.task[task_id].update({
            'description': 'Fixes for {}'.format(self.ticket_id),
            'owner': OWNER,
            'custom_fields': params,
        })
        return task_url
