# !/usr/bin/env python
# -*- coding: utf-8 -*-

import os
from jinja2 import Environment, FileSystemLoader
from startrek_client import Startrek


class StTicket(object):
    def __init__(self, api_url, token):
        self.subj = "[New Security Bugs] Stable Channel Update for Desktop v {0:}"
        self.queue = "BROWSER"
        self.assignees = "naumov-al"
        self.folowers = ["riosvk", "dmgor", "lof84", "naumov-al"]
        self.st_client = Startrek(useragent="Sandbox crbug alert", base_url=api_url, token=token)
        self.ticket_id = ""
        path = os.path.abspath(__file__)
        self.env = Environment(loader=FileSystemLoader(os.path.join(os.path.dirname(path), "templates")))

    def _is_issue_exists(self, queue, subj):
        issues = None
        try:
            issues = self.st_client.issues.find(filter={"queue": queue, "summary": subj, "security": "Yes",
                                                        "status": ["open", "needInfo", "closed", "resolved"]})
        except Exception as ex:
            print("[-] St search similar ticket failed: {}".format(ex))

        if issues:
            return True

        return False

    def create_for_rel(self, vulns):
        for rel, rel_vulns in vulns.items():
            subj = self.subj.format(rel)
            if self._is_issue_exists(self.queue, subj):
                return
            t = self.env.get_template("ChromeBugs.tpl")
            descr = t.render(rel=rel, vulns=rel_vulns)
            try:
                ticket = self.st_client.issues.create(queue=self.queue, summary=subj, assignee=self.assignees,
                                             description=descr, followers=self.folowers, tags=["crbug"],
                                             security="Yes")
                print("[+] St ticket {}".format(ticket.key))
                self.ticket_id = ticket.key
            except Exception as ex:
                print("[-] St ticket creation failed: {}".format(ex))
    
    def add_comment(self, message):
        ticked_id = self.get_created_ticket()
        try:
            issue = self.st_client.issues[ticked_id]
            comment = issue.comments.create(text=message)
        except Exception as ex:
            print("[-] Comment creation for {} failed".format(ticked_id))

    def get_created_ticket(self):
        if self.ticket_id:
            return "{id}".format(id=self.ticket_id)
        return ""
