import os.path

from sandbox.projects import resource_types
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask
from sandbox.projects.common.nanny import nanny

import sandbox.projects.common.constants as consts

from sandbox.sandboxsdk.parameters import SandboxArcadiaUrlParameter
from sandbox.sandboxsdk.paths import copy_path
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia, ArcadiaTestData


class BuildAtomPromolibProxyConfig(nanny.ReleaseToNannyTask, ArcadiaTask):

    """Builds NGINX config and necessary scripts for Promolib atom proxy"""

    type = "BUILD_ATOM_PROMOLIB_PROXY_CONFIG"

    execution_space = 1000

    input_parameters = [SandboxArcadiaUrlParameter]

    release_to = ["manokk"]

    def do_execute(self):
        url = self.ctx[consts.ARCADIA_URL_KEY]
        parsed_url = Arcadia.parse_url(url)
        test_data_path = parsed_url.path.rstrip("/")
        assert parsed_url.revision
        assert test_data_path.endswith("arcadia")
        test_data_path = test_data_path[:-8] + "/arcadia_tests_data/"

        path = "pers/rerank_service/nginx"

        arcadia_tests_data_dir = None
        test_data_url = Arcadia.replace(url, path=test_data_path + path)
        data_dir = ArcadiaTestData.get_arcadia_test_data(self, test_data_url)
        if not arcadia_tests_data_dir:
            arcadia_tests_data_dir = data_dir[:-len(path)]

        assert arcadia_tests_data_dir

        nginx_conf_path = self.abs_path("nginx_conf")
        resources = self.abs_path()

        copy_path(
            os.path.join(arcadia_tests_data_dir, path, "locations"),
            os.path.join(nginx_conf_path, "locations")
        )
        copy_path(
            os.path.join(arcadia_tests_data_dir, path, "static"),
            os.path.join(nginx_conf_path, "static")
        )
        copy_path(
            os.path.join(arcadia_tests_data_dir, path, "nginx.conf.in"),
            os.path.join(nginx_conf_path, "nginx.conf.in")
        )

        tar = os.path.join(resources, "nginx_conf.tar.gz")
        run_process(['tar', '-czf', tar, "."], work_dir=nginx_conf_path, log_prefix='build_archive')

        self.create_resource(
            description="nginx config from %s" % str(parsed_url),
            resource_path=tar,
            resource_type=resource_types.PERS_ATOM_PROMOLIB_NGINX_CONFIG,
            arch=self.arch
        )

        copy_path(
            os.path.join(arcadia_tests_data_dir, path, "loop.conf"),
            os.path.join(resources, "loop.conf")
        )
        self.create_resource(
            description="loop.conf from %s" % str(parsed_url),
            resource_path=os.path.join(resources, "loop.conf"),
            resource_type=resource_types.PERS_ATOM_PROMOLIB_NGINX_LOOP_CONF,
            arch=self.arch
        )

        copy_path(
            os.path.join(arcadia_tests_data_dir, path, "iss_hook_notify"),
            os.path.join(resources, "iss_hook_notify")
        )
        self.create_resource(
            description="iss_hook_notify from %s" % str(parsed_url),
            resource_path=os.path.join(resources, "iss_hook_notify"),
            resource_type=resource_types.PERS_ATOM_PROMOLIB_NGINX_ISS_HOOK_NOTIFY
        )


__Task__ = BuildAtomPromolibProxyConfig
