import os

from sandbox import sdk2

from sandbox.projects.common.yappy.base_build_python_bundle import BaseBuildPythonBundle
from sandbox.projects.BuildYDL import BuildYDL


class BuildAvtomatika(BaseBuildPythonBundle):
    class Requirements(BaseBuildPythonBundle.Requirements):
        disk_space = 3 * 1024

    @property
    def github_context(self):
        return '[Sandbox] Build and test'

    @property
    def bundle_description(self):
        return 'Avtomatika bundle'

    @property
    def project_conf(self):
        return {
            'github': {
                'report_statuses': self.Parameters.report_github_statuses
            }
        }

    def after_install(self):
        with self.info_section('<install> static files'), sdk2.helpers.ProcessLog(self, 'install_static') as pl:
            self.run_command(
                [
                    self.Context.python_bin,
                    os.path.join(self.Context.sources_path, 'avtomatika', 'manage.py'), 'collectstatic',
                    '--settings', 'avtomatika.settings.web',
                    '--noinput',
                ],
                process_log=pl,
            )

    def before_build(self):
        with self.info_section('<test> components_app'), sdk2.helpers.ProcessLog(self, 'test_components_app') as pl:
            self.run_command(
                [
                    self.Context.python_bin,
                    '-m', 'pytest',
                    '-v', os.path.join(self.Context.sources_path, 'components_app', 'tests', 'suite.py'),
                ],
                process_log=pl,
            )

        with self.info_section('<test> avtomatika'), sdk2.helpers.ProcessLog(self, 'test_avtomatika') as pl:
            self.run_command(
                [
                    self.Context.python_bin,
                    '-m', 'pytest',
                    '-v', os.path.join(self.Context.sources_path, 'avtomatika', 'tests', 'suite.py'),
                ],
                process_log=pl,
            )

    def after_build(self, additional_bundled_files=None):
        with self.info_section('<build> info files'), sdk2.helpers.ProcessLog(self, 'settings_diff') as pl:
            settings_diff = self.run_command(
                [
                    self.Context.python_bin,
                    os.path.join(self.Context.sources_path, 'avtomatika', 'manage.py'), 'diffsettings',
                    '--settings', 'avtomatika.settings.web',
                ],
                process_log=pl,
                check_output=True,
            )

            django_settings = BuildYDL.parse_django_settings(settings_diff)
            static_files_path = django_settings.get(
                'STATIC_ROOT',
                os.path.join(self.Context.sources_path, 'collected_static')
            )

        additional_bundled_files = (
            (static_files_path, 'collected_static'),
        )

        super(BuildAvtomatika, self).after_build(additional_bundled_files=additional_bundled_files)
