# -*- coding: utf-8 -*-

import json
import logging
import os

from sandbox import sdk2

from sandbox.projects.common.yappy.base_build_ui import BaseBuildUI
from sandbox.projects.resource_types import search_priemka_releasers


class AvtomatikaUIBundle(sdk2.Resource):
    """
    Transpiled, minimized and archived frontend files.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = search_priemka_releasers


class BuildAvtomatikaUI(BaseBuildUI):
    class Context(BaseBuildUI.Context):
        tests_log_path = None
        tests_results = {}

    class Parameters(BaseBuildUI.Parameters):
        pass

    @property
    def github_context(self):
        return '[Sandbox] Build and test'

    @property
    def project_conf(self):
        return {
            'github': {
                'report_statuses': self.Parameters.report_github_statuses
            }
        }

    @property
    def bundle_resource_type(self):
        return AvtomatikaUIBundle

    @property
    def bundle_description(self):
        return 'Avtomatika UI bundle'

    def before_build(self):
        """
        Runs tests, creates resources, handles errors.
        """
        # FIXME: read filename from package.json or config/main.js
        self.Context.tests_log_path = os.path.join(self.Context.sources_path, 'jest-results.json')

        try:
            returncode, _, _ = self.node.run_script(
                'test',
                cwd=self.Context.sources_path,
            )

            self._check_tests_results(returncode)
            logging.info('>>> TESTS COMPLETED SUCCESSFULLY')

        except Exception as e:
            logging.exception('failed to run tests')
            self.fail_task('failed to run tests: {}: {}'.format(e.__class__.__name__, e))

        logging.info('>>> TESTS COMPLETED')

    def _check_tests_results(self, returncode):
        """
        Fails task if any test failed.
        """
        try:
            with open(self.Context.tests_log_path, 'r') as f:
                self.Context.tests_results = json.load(f)

            self.Context.failed_tests_count = int(self.Context.tests_results.get('numFailedTests', 0))

            if self.Context.failed_tests_count != 0:
                self.fail_task('{} test(s) failed'.format(
                    self.Context.tests_results.get('numFailedTests', 'some')
                ))
            else:
                self.set_info('{} test(s) passed'.format(
                    self.Context.tests_results.get('numPassedTests', 'all')
                ))

        except Exception as e:
            logging.exception('failed to read test results')
            self.fail_task('failed to read test results: {}: {}'.format(e.__class__.__name__, e))

        if returncode != 0:
            self.fail_task('tests failed with {} code'.format(returncode))
