# -*- coding: utf-8 -*-

import os

# stuff from sandbox
from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.paths import copy_path

# auxiliarily gencfg stuff
from sandbox.projects.common.gencfg import utils as config_generator_utils
from sandbox.projects.common.gencfg.task import IGencfgBuildTask
from sandbox.sandboxsdk.process import run_process


class GitTagParameter(SandboxStringParameter):
    name = 'tag'
    description = 'Svn tag'
    default_value = 'trunk'


class BuildBalancerConfigGenerator(IGencfgBuildTask):
    type = 'BUILD_BALANCER_CONFIG_GENERATOR'

    input_parameters = [GitTagParameter]

    SVN_COMMIT_KEY = 'svn_commit'

    def get_generated_configs_path(self):
        return self.abs_path('generated_configs')

    def get_src_path(self):
        return self.abs_path('gencfg')

    def get_balancer_src_path(self):
        return os.path.join(self.get_src_path(), 'custom_generators', 'balancer_gencfg')

    def arcadia_info(self):
        return self.ctx.get(BuildBalancerConfigGenerator.GIT_COMMIT_KEY, None), 'balancer-gencfg/%s' % (self.ctx[GitTagParameter.name]), None

    def on_enqueue(self):
        self.ctx['generated_configs_id'] = self._create_resource(
            self.descr, self.get_generated_configs_path(),
            resource_types.GENCFG_GENERATED_BALANCER_CONFIGS, arch='any'
        ).id

    def on_execute(self):
        config_generator_utils.clone_gencfg_all(self.get_src_path(), 'full', tag=self.ctx[GitTagParameter.name])
        self.ctx[BuildBalancerConfigGenerator.GIT_COMMIT_KEY] = self.get_last_commit(os.path.join(self.get_src_path(), 'custom_generators', 'balancer_gencfg'))

        run_process(["bash", "./install.sh", "tests", "build"], work_dir=self.get_src_path(), log_prefix="install")
        run_process(["bash", "./gen.sh", "curdb"], work_dir=self.get_balancer_src_path(), log_prefix="generate")

        copy_path(os.path.join(self.get_src_path(), "generated"), self.get_generated_configs_path())

        self.generate_diff(self.get_src_path(), ['commitbalancer'], "^balancer-stable-\d+-r\d+$")

    def on_release(self, additional_parameters):
        release_status = additional_parameters.get('release_status')
        release_subject = additional_parameters.get('release_subject')

        self.mark_released_resources(release_status)

        self.report_mail_on_release(release_status, release_subject)
        self.report_startrek_on_release(self.ctx[GitTagParameter.name])


__Task__ = BuildBalancerConfigGenerator
