# coding: utf-8

from sandbox.projects.common.balancer import base_balancer_configs
import sandbox.projects.rtc_balancer as rtc_balancer
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects.common import utils
import sandbox.sandboxsdk.process as sdk_process
import os
import copy


class VaultOwner(SandboxStringParameter):
    name = 'vault_owner'
    description = 'Vault owner'
    default_value = 'SEARCH-RELEASERS'
    required = True


class VaultName(SandboxStringParameter):
    name = 'vault_name'
    description = 'Vault name'
    default_value = 'nanny_oauth_token'
    required = True


class Task(base_balancer_configs.BaseTask):
    """Generate, test and release tarball with balancer configs"""

    type = 'BUILD_BALANCER_CONFIGS'
    input_parameters = copy.copy(base_balancer_configs.BaseTask.input_parameters)
    input_parameters.extend([
        VaultOwner,
        VaultName,
    ])

    resource_for_autorelease = str(rtc_balancer.BALANACER_GENCFG_CONFIGS_TGZ)

    def run_build(self):
        my_env = os.environ.copy()
        nanny_oauth = self.get_vault_data(
            utils.get_or_default(self.ctx, VaultOwner),
            utils.get_or_default(self.ctx, VaultName)
        )
        my_env['NANNY_OAUTH_TOKEN'] = nanny_oauth

        sdk_process.run_process(
            ['bash', './gen-configs-balancer.sh', 'api'],
            work_dir=self.generator_root,
            log_prefix='generate',
            environment=my_env
        )

        sdk_process.run_process(
            ['tar', '-czf', os.path.join(os.path.abspath(''), 'balancer_configs.tgz'), 'generated'],
            work_dir=self.generator_root,
            log_prefix='tar_configs'
        )

        sdk_process.run_process(
            ['cp', '-r', 'generated', os.path.join(os.path.abspath(''), 'configs')],
            work_dir=self.generator_root,
            log_prefix='copy_dir_configs'
        )

        self.create_resource(
            arch='any',
            attributes={'ttl': 1},
            description=self.descr,
            resource_path='configs',
            resource_type='BALANACER_GENCFG_CONFIGS_DIR',
        )

        balancer_configs = self.create_resource(
            arch='any',
            attributes={'ttl': 1},
            description=self.descr,
            resource_path='balancer_configs.tgz',
            resource_type='BALANACER_GENCFG_CONFIGS_TGZ',
        )

        self.test_ctx['balancer_gencfg_configs_id'] = balancer_configs.id
        self.mark_resource_ready(balancer_configs)


__Task__ = Task
