# -*- coding: utf-8 -*-
import os

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.common.arcadia import sdk
from sandbox.projects.common.constants import YMAKE_BUILD_SYSTEM


class BuildBegemotExecutable2(sdk2.Task):

    _LOCAL_RELEASE_DIR = 'release'

    class Parameters(sdk2.Task.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl("Svn url for arcadia", required=True)
        arcadia_patch = sdk2.parameters.String(
            "Apply patch (diff file rbtorrent, paste.y-t.ru link or plain text). Doc: https://nda.ya.ru/3QTTV4",
            multiline=True,
            default=""
            )
        with sdk2.parameters.String("Build type", required=True) as build_type:
            build_type.values.release = build_type.Value("Release", default=True)
            build_type.values.debug = "Debug"
            build_type.values.profile = "Profile"
            build_type.values.coverage = "Coverage"
            build_type.values.relwithdebinfo = "Release with debug info"
            build_type.values.valgrind = "Valgrind (debug)"
            build_type.values.valgrind_release = "Valgrind (release) (only for build with ya)"
        with sdk2.parameters.String("Build with specified sanitizer") as sanitize:
            sanitize.values.none = build_type.Value('None', default=True)
            sanitize.values.address = "address"
            sanitize.values.leak = "leak"
            sanitize.values.memory = "memory"
            sanitize.values.thread = "thread"
            sanitize.values.undefined = "undefined"

    class Context(sdk2.Task.Context):
        executable_res_id = None
        evlogdump_res_id = None

    def on_enqueue(self):
        self.Context.executable_res_id = resource_types.BEGEMOT_EXECUTABLE(
            self, "Build begemot executable", os.path.basename(resource_types.BEGEMOT_EXECUTABLE.arcadia_build_path)
        ).id
        self.Context.evlogdump_res_id = resource_types.BEGEMOT_EVLOGDUMP(
            self, "event log custom dumper", os.path.basename(resource_types.BEGEMOT_EVLOGDUMP.arcadia_build_path)
        ).id

    def on_execute(self):
        targets = [
            resource_types.BEGEMOT_EXECUTABLE.arcadia_build_path,
            resource_types.BEGEMOT_EVLOGDUMP.arcadia_build_path,
        ]
        release_dir = str(self.path(self._LOCAL_RELEASE_DIR))
        sdk2.path.Path(os.path.abspath(str(release_dir))).mkdir(mode=0o755, exist_ok=True)

        sdk.do_build(
            YMAKE_BUILD_SYSTEM,
            self.Parameters.checkout_arcadia_from_url,
            targets,
            self.Parameters.build_type,
            clear_build=True,
            results_dir=release_dir,
            checkout=True,
            def_flags={'SANDBOX_TASK_ID': self.id}
        )
