# -*- coding: utf-8 -*-

from sandbox.common.types.client import Tag
from sandbox.projects import resource_types
from sandbox.projects.common.BaseBuildPythonBundleTask import BaseBuildPythonBundleTask
from sandbox.projects.common.nanny import nanny

from sandbox.sandboxsdk.parameters import SandboxGitUrlParameter


class BkhtTickersAppRepositoryPath(SandboxGitUrlParameter):
    name = 'bkht_tickers_app_repository_path'
    description = 'GIT repository with bkht@ tickers app code'
    #default_value = 'https://x-oauth-token:AQAD-qJSJkCbAAAF3R0isLAfYk2LuI4Dkb5geP0@bb.yandex-team.ru/scm/~bkht/tickers-app.git'
    default_value = 'ssh://git@bb.yandex-team.ru/~bkht/tickers-app.git'


class BuildBkhtTickersApp(BaseBuildPythonBundleTask, nanny.ReleaseToNannyTask):
    type = 'BUILD_BKHT_TICKERS_APP'

    owners = ['bkht']

    client_tags = Tag.LINUX_PRECISE

    cores = 1

    REPO_URL_PARAMETER = BkhtTickersAppRepositoryPath

    VAULT_OWNER = 'bkht'

    SSH_KEY_NAME = 'BKHT_BB_SSH_KEY'

    RESOURCE_TYPE_CODE = resource_types.BKHT_TICKERS_APP_CODE

    RESOURCE_TYPE_VENV_ARCHIVE = resource_types.BKHT_TICKERS_APP_VIRTUAL_ENVIRONMENT

    CODE_EXCLUDE_PATTERNS = ['^\./bin',
                             '^\./docker',
                             '\./requirements\.txt'
                             '^\./\.git']

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        BaseBuildPythonBundleTask.on_release(self, additional_parameters)


__Task__ = BuildBkhtTickersApp
