# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask, BUILD_DIR


class BuildMarketBuker(YaMakeTask):
    type = 'BUILD_MARKET_BUKER_BIN'

    execution_space = 100 * 1024  # 100 GB

    input_parameters = [p for p in YaMakeTask.input_parameters if p.name not in ['targets']]

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True

    @property
    def targets_description(self):
        return [
            ('market/buker/bin/offline_buker/offline_buker', 'buker', resource_types.MARKET_BUKER_BIN, 'market/buker'),
            ('market/buker/bin/buker/buker-bin', 'buker_online', resource_types.MARKET_BUKER_BIN_ONLINE, 'market/buker'),
        ]

    def export_build_resources(self):
        src_path = BUILD_DIR

        for res in self.targets_description:
            res_path, filename, res_type, _ = res
            to_path = self.abs_path(filename)
            from_path = os.path.join(src_path, res_path)
            if os.path.isdir(from_path):
                shutil.copytree(from_path, to_path)
            else:
                shutil.copy(from_path, to_path)
            self.create_resource(filename, to_path, res_type)

    def do_execute(self):
        YaMakeTask.do_execute(self)
        self.export_build_resources()

    def get_targets(self):
        return [res[3] for res in self.targets_description]


__Task__ = BuildMarketBuker
