# coding: utf-8


import os
import platform

from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects import resource_types
import urllib
import sandbox.common.types.misc as ctm


class BuildCMake(SandboxTask):
    '''
    Build cmake from source
    '''
    type = 'BUILD_CMAKE'
    dns = ctm.DnsType.DNS64

    cmake_version = '2.8.12.1'
    cmake_source_url = 'http://www.cmake.org/files/v2.8/cmake-%s.tar.gz' % cmake_version
    cmake_patch_version = '1'

    def on_execute(self):
        self.create_resource(
            description="CMake bundle",
            resource_path="cmake.tgz",
            resource_type=resource_types.CMAKE_EXECUTABLE,
            attributes={
                "version": '%s-%s' % (self.cmake_version, self.cmake_patch_version),
                "ttl": 'inf',
                "platform": platform.platform()
            }
        )

        cmake_tar_gz_path = self.abs_path('cmake.tgz')

        urllib.urlretrieve(self.cmake_source_url, cmake_tar_gz_path)
        os.chdir(self.abs_path(''))
        run_process(['tar', '-xf', cmake_tar_gz_path],
                    shell=True,
                    log_prefix='tar')

        Arcadia.export(
            "arcadia:/arc/trunk/arcadia/sandbox/projects/BuildCMake/cmake-%s-%s.diff" % (self.cmake_version, self.cmake_patch_version),
            "./cmake-%s.diff" % self.cmake_version
        )

        os.mkdir('build')
        os.chdir(self.abs_path('cmake-%s' % self.cmake_version))
        patch_fd = open(self.abs_path('cmake-%s.diff' % self.cmake_version))
        run_process(['patch', '-p1'], stdin=patch_fd)
        run_process(['sh', './bootstrap', '--prefix=%s' % self.abs_path('build'), '--', '-DCMAKE_BUILD_TYPE=RELEASE'], log_prefix='cmake')
        run_process(['make', 'VERBOSE=1', '-j', str(self.client_info['ncpu']), 'install'], log_prefix='make')

        os.chdir(self.abs_path('build'))
        run_process(
            ['tar', '-czf', self.abs_path('cmake.tgz'), './'],
            shell=True,
            log_prefix="tar"
        )


__Task__ = BuildCMake
