# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildCMake import BuildCMake
# noinspection PyProtectedMember
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildCMakeForAll(BuildForAllTask):
    type = 'BUILD_CMAKE_FOR_ALL'
    input_parameters = [PlatformsListParameter]
    release_to = 'sandbox-releases@yandex-team.ru'

    # BuildForAllTask fields
    subtask_type = BuildCMake
    subtask_description = 'Building cmake {version} for {target}'
    resource_type = resource_types.CMAKE_EXECUTABLE
    resource_description = 'cmake {version} for {target}'


__Task__ = BuildCMakeForAll
