# -*- coding: utf-8 -*-

import os
import shutil

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask, BUILD_DIR


class BuildMarketCataloger(YaMakeTask):
    type = 'BUILD_MARKET_CATALOGER_BIN'

    execution_space = 100 * 1024  # 100 GB

    input_parameters = [p for p in YaMakeTask.input_parameters if p.name not in ['targets']]

    def initCtx(self):
        self.ctx['fail_on_any_error'] = True

    @property
    def targets_description(self):
        return [
            ('market/cataloger/bin/offline_cataloger/offline_cataloger', 'cataloger', resource_types.MARKET_CATALOGER_BIN, 'market/cataloger'),
            ('market/cataloger/bin/marketcataloger/marketcataloger-bin', 'cataloger_online', resource_types.MARKET_CATALOGER_BIN_ONLINE, 'market/cataloger'),
        ]

    def export_build_resources(self):
        src_path = BUILD_DIR

        for res in self.targets_description:
            res_path, filename, res_type, _ = res
            to_path = self.abs_path(filename)
            from_path = os.path.join(src_path, res_path)
            if os.path.isdir(from_path):
                shutil.copytree(from_path, to_path)
            else:
                shutil.copy(from_path, to_path)
            self.create_resource(filename, to_path, res_type)

    def do_execute(self):
        YaMakeTask.do_execute(self)
        self.export_build_resources()

    def get_targets(self):
        return [res[3] for res in self.targets_description]


__Task__ = BuildMarketCataloger
