# coding: utf-8


from sandbox.projects import resource_types
from sandbox.projects.common.build import BuildForAllTask, ScriptBuildTask
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.process import run_process
from sandbox.common.types import misc


class ClangVersion(BuildForAllTask.VersionParameter):
    description = 'Clang version'
    default_value = '3.8.0'


class AdditionalOptions(SandboxStringParameter):
    description = 'Additional build options'
    default_value = ''
    name = 'additional_options'


class BuildClang(ScriptBuildTask.ScriptBuildTask):
    type = 'BUILD_CLANG'
    # Enable DNS64 - sometimes there are no IPv6 entries in DNS response for llvm.org
    dns = misc.DnsType.DNS64
    input_parameters = [ClangVersion, ScriptBuildTask.UseSandboxGCCParameter, BuildForAllTask.DoNotRemoveResourcesParameter, AdditionalOptions]
    execution_space = 50 * 1024

    # ScriptBuildTask fields
    tool_name = 'clang'
    inplace_archive = True
    resource_type = resource_types.CLANG_TOOLKIT

    def initCtx(self):
        # timeout after 24 hours - we have PGO and a single half dead Darwin server in the Sandbox
        self.ctx['kill_timeout'] = 24 * 60 * 60

    def run_script(self, version, result_dir_path, env, extra_params=None):
        params = []
        if extra_params:
            params += extra_params

        opts = self.ctx.get(AdditionalOptions.name)
        if opts:
            params += opts.split(' ')

        params += ['--logs={logsdir}'.format(logsdir=self.path(self.logs_dir_name))]
        params += ['--version={version}'.format(version=version)]

        args = [
            '/skynet/python/bin/python',
            self.abs_path('scripts/build_clang.py')
        ] + params + [
            result_dir_path
        ]

        run_process(args, shell=True, log_prefix='build', environment=env)


__Task__ = BuildClang
