# coding: utf-8

from sandbox.projects import resource_types
from sandbox.projects.BuildClang import BuildClang
from sandbox.projects.common import constants
from sandbox.projects.common.build.BuildForAllTask import BuildForAllTask, PlatformsListParameter


class BuildClangForAll(BuildForAllTask):
    type = 'BUILD_CLANG_FOR_ALL'
    input_parameters = list(BuildClang.input_parameters) + [PlatformsListParameter]
    release_to = 'sandbox-releases@yandex-team.ru'
    inherit_notifications = True

    target_to_host_map = {
        'linux': constants.SANDBOX_LINUX_UBUNTU_12_PRECISE,
        'freebsd9': 'freebsd9',
        'darwin': constants.SANDBOX_DARWIN_OLD_VERSION,
    }

    # BuildForAllTask fields
    subtask_type = BuildClang
    subtask_description = 'Building Clang {version} for {target}'
    resource_type = resource_types.CLANG_TOOLKIT
    resource_description = 'Clang {version} for {target}'


__Task__ = BuildClangForAll
