# coding: utf-8
from sandbox.projects import resource_types
from sandbox.projects.common.iss.BuildFromArtifactoryTask import BuildFromArtifactoryTask, create_version_parameter

ARTIFACT_DIR = 'http://artifactory.yandex.net/artifactory/qe/ru/yandex/schedulers/cluster-service/cluster-service-standalone/'


class BuildClusterApi(BuildFromArtifactoryTask):
    """
        Get cluster api jar from maven, make it a resource and register in nanny on release
    """
    type = 'BUILD_CLUSTER_API'

    input_parameters = [
        create_version_parameter(ARTIFACT_DIR, 'Cluster API artifact version (standalone)')
    ]

    def _resource_path(self):
        return "clusterapi.jar"

    def _artifact_dir(self):
        return ARTIFACT_DIR

    def _artifact_basename_template(self):
        return "cluster-service-standalone-{version}-runnable.jar"

    def _resource_type(self):
        return resource_types.CLUSTER_API_JAR

    def _resource_id_context_key(self):
        return 'cluster_api_jar_id'


__Task__ = BuildClusterApi
