# -*- coding: utf-8

import os
import re
import logging

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters, svn

from sandbox.projects import resource_types
from sandbox.sandboxsdk.channel import channel
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
import sandbox.projects.common.constants as consts
from sandbox.projects.common.utils import get_svn_info


class BuildClustermaster(CommonBuildTask):
    type = 'BUILD_CLUSTERMASTER'

    class ClustermasterBlock(parameters.SandboxInfoParameter):
        name = 'info_field'
        description = 'Clustermaster Binaries'

    input_parameters = CommonBuildTask.input_parameters + [ClustermasterBlock]

    client_tags = ctc.Tag.Group.LINUX

    TARGET_RESOURCES = (
        (resource_types.CM_WORKER, 'tools/clustermaster/worker/worker'),
        (resource_types.CM_MASTER, 'tools/clustermaster/master/master'),
        (resource_types.CM_SOLVER, 'tools/clustermaster/solver/solver'),
    )

    def initCtx(self):
        self.ctx['build_bundle'] = False  # don't know why
        CommonBuildTask.initCtx(self)

    def on_execute(self):
        os.putenv('LD_LIBRARY_PATH', '')  # don't know why
        CommonBuildTask.on_execute(self)
        arcadia_url = self.ctx.get(consts.ARCADIA_URL_KEY)
        self.ctx['arcadia_revision'] = get_svn_info(arcadia_url)['commit_revision']

    def on_release(self, additional_parameters):
        channel.task = self

        resource_ids = []
        for resource in self.list_resources():
            logging.debug('resource "%s" %s %s', resource, resource.type.releasable and "releasable" or "-", resource.arch)
            if resource.type.releasable:
                resource_ids.append(str(resource.id))

        branch = additional_parameters.get('release_comments').strip()

        arcadia_url = self.ctx.get(consts.ARCADIA_URL_KEY)
        m = re.search("/clustermaster\/cm-stable-(\d+)/", arcadia_url)
        if not branch and m:
            branch = m.group(1)

        if not branch:
            cm_path = svn.Arcadia.get_arcadia_src_dir(arcadia_url)
            logging.debug("arcadia srcdir %s", cm_path)
            branch_txt = os.path.join(cm_path, "tools", "clustermaster", "branch.txt")
            with open(branch_txt) as f:
                branch = int(f.readline())
                f.close()

        logging.debug('major branch %s', branch)
        subtask_ctx = {'resource_ids': ",".join(resource_ids),
                'branch': branch,
                'revision': self.ctx.get('arcadia_revision', ''),
                'repository_id': 'search'}
        self.create_subtask(task_type='BUILD_CLUSTERMASTER_DEB',
                               input_parameters=subtask_ctx,
                               description='Subtask of task %s (%s)' % (self.id, self.descr),
                               arch='linux')
        # CommonBuildTask.on_release(self, additional_parameters)


__Task__ = BuildClustermaster
