# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.projects import resource_types

from sandbox.projects.common.mediasearch.build import BaseMediaBuildTask


class BuildCvdupBundle(BaseMediaBuildTask):
    type = "BUILD_CVDUP_BUNDLE"

    class TimestampParameter(SandboxStringParameter):
        name = 'timestamp'
        description = 'Release machine integration parameter (leave empty when launching not from rm images_semidups)'
        default_value = ''

    input_parameters = BaseMediaBuildTask.input_parameters + [TimestampParameter]


    def get_binaries(self):
        return (
            resource_types.CVDUP_IMAGEREDUCE,
            resource_types.CVDUP_TESTTOOL,
            resource_types.CV_IMAGEPARSER,
            resource_types.IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE,
        )

    def get_configs(self):
        return (
            resource_types.CVDUP_IMAGEPARSER_CONFIG,
        )


__Task__ = BuildCvdupBundle
