# coding: utf-8

# $Header$

import logging

from sandbox.projects import resource_types
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.parameters import SandboxBoolParameter
from sandbox.sandboxsdk.parameters import SandboxRadioParameter
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask


class ReleaseStatus(SandboxRadioParameter):
    choices = [(_, _) for _ in ("none", "prestable", "stable", "testing", "unstable")]
    description = '"stable" Will be immediately enqueued to production deploy, so use with care'
    default_value = "none"
    name = 'release_status'


class ReleaseUniqDataOnly(SandboxBoolParameter):
    name = 'release_uniq_data'
    description = "Release only if last released sy.hash has different md5"
    default_value = True


class ResourceURL(SandboxStringParameter):
    description = 'Url for cy.hash'
    default_value = 'rsync://brasero.search.yandex.net/yaca/current/src/misc/cy.hash'
    name = 'resource_url'


class SkipTest(SandboxBoolParameter):
    name = 'skip_test'
    description = "Don't test data. I DO KNOW what I'm doing"
    default_value = False


class BuildCyHash(nanny.ReleaseToNannyTask, SandboxTask):
    type = 'BUILD_CY_HASH'

    description = 'cy.hash, SEPE-7889, SEPE-7325 '
    execution_space = 512
    notify_if_finished = None
    release_to = None

    input_parameters = [ReleaseStatus, ReleaseUniqDataOnly, ResourceURL, SkipTest]

    def test_data(self):
        raise Exception("Tests not implemented yet")

    def on_execute(self):
        self.remote_copy(self.ctx['resource_url'], '.')

        self.create_resource(
            arch='any',
            attributes={'ttl': 1},
            description='SEPE-7889, SEPE-7325',
            resource_path='cy.hash',
            resource_type=resource_types.CY_HASH
        )

        if self.ctx['skip_test'] is not True:
            self.test_data()
            logging.info('All tests passed')
        else:
            logging.warning("Flag 'skip_test' is set by releaser, tests skipped")

        if self.ctx['release_status'] is not 'none':
            check_already_released = False
            if self.ctx['release_uniq_data'] is True:
                check_already_released = str(resource_types.CY_HASH)

            releaser = self.create_subtask(
                task_type='RELEASE_ANY',
                inherit_notifications=True,
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_status'],
                },
                description="cy.hash (task id: " + str(self.id) + ') autorelease'
            )

            self.info = "Subtask {} runned, waiting it's decision about release.\n\n".format(releaser.id)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        self.mark_released_resources(self.ctx['release_status'], ttl=180)


__Task__ = BuildCyHash
