# -*- coding: utf-8 -*-

import os

from sandbox.sandboxsdk.channel import channel

import sandbox.projects.common.build.parameters as build_params

from sandbox.projects import resource_types
from sandbox.projects.common.build.YaMake import YaMakeTask


class BuildDBMergeTool(YaMakeTask):

    type = 'BUILD_DBMERGE_TOOL'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    def get_resources(self):
        resources = {
            'description': 'Build gemini dbmerge tool',
            'resource_path': os.path.basename(resource_types.DBMERGE_TOOL.arcadia_build_path),
            'resource_type': resource_types.DBMERGE_TOOL,
        }
        return {'project': resources}

    def get_targets(self):
        return [
                    resource_types.DBMERGE_TOOL.arcadia_build_path,
                ]

    def get_arts(self):
        return [
                    {
                        'path': resource_types.DBMERGE_TOOL.arcadia_build_path,
                        'dest': '',
                    },
                ]

    def post_build(self, source_dir, output_dir, pack_dir):
        resources = channel.sandbox.list_resources(resource_type=resource_types.DBMERGE_TOOL, task_id=self.id)
        for resource in resources:
            if self.ctx.get(resource_types.DBMERGE_TOOL.name):
                self.save_parent_task_resource(resource.path, self.ctx[resource_types.DBMERGE_TOOL.name])


__Task__ = BuildDBMergeTool
