# -*- coding: utf-8 -*-

from .parameters import DelayedViewEntityBaseYtTablePath, UseExistingEntityBaseYtTable
from .parameters import EntityMainBaseYtTablePath, EntityDeltaBaseYtTablePath
from .parameters import EmptyEntityBaseTrie
from .parameters import get_params as get_specific_params
from sandbox.projects import resource_types
from sandbox.sandboxsdk import environments
import os
import sandbox.projects.video.quality.delayed_view as delayed_view
import sandbox.sandboxsdk.task as sdk_task
import sys


__TRIE_FILE_NAME = 'delayed_view_entity_base_trie'


def create_trie_resource(task):
    return task.create_resource(
        description='delayed view entity base trie',
        resource_path=__TRIE_FILE_NAME,
        resource_type=resource_types.DELAYED_VIEW_ENTITY_BASE_TRIE,
        attributes={'ttl': 'inf'}
    )


def table_exists(yt_proxy, yt_token, yt_table_path):
    import yt.wrapper as yt
    yt_client = yt.YtClient(proxy=yt_proxy, token=yt_token)
    return yt_client.exists(yt_table_path)


class BuildDelayedViewEntityBaseTrie(sdk_task.SandboxTask):
    '''Build entity base trie for delayed view in video-search'''

    type = 'BUILD_DELAYED_VIEW_ENTITY_BASE_TRIE'

    input_parameters = delayed_view.get_common_params() + get_specific_params()

    environment = (
        environments.PipEnvironment('yandex-yt'),
    )

    def __build_base_on_yt_stage(self):
        yt_proxy, yt_token = delayed_view.get_yt_params(self)

        entity_main_base_yt_table_path = self.ctx[EntityMainBaseYtTablePath.name]
        entity_delta_base_yt_table_path = self.ctx[EntityDeltaBaseYtTablePath.name]
        delayed_view_entity_base_yt_table_path = self.ctx[DelayedViewEntityBaseYtTablePath.name]
        use_existing_entity_base_yt_table = self.ctx[UseExistingEntityBaseYtTable.name]

        if (
            use_existing_entity_base_yt_table and
            table_exists(yt_proxy, yt_token, delayed_view_entity_base_yt_table_path)
        ):
            return

        cmd = [
            sys.executable,
            os.path.join(os.path.dirname(__file__), 'yt_entity_base_builder.py'),
            '--yt_proxy', yt_proxy,
            '--entity_main_base_yt_table_path', entity_main_base_yt_table_path,
            '--entity_delta_base_yt_table_path', entity_delta_base_yt_table_path,
            '--delayed_view_entity_base_yt_table_path', delayed_view_entity_base_yt_table_path
        ]

        delayed_view.run_in_yt_env(cmd, 'yt_entity_base_builder', yt_token)

    def __create_ya_make_trie_ops_subtask_stage(self):
        delayed_view.create_ya_make_trie_ops_subtask(self)

    def __save_ya_make_trie_ops_subtask_result_stage(self):
        delayed_view.save_ya_make_trie_ops_subtask_result(self)

    def __build_trie_stage(self):
        delayed_view_entity_base_trie_resource = create_trie_resource(self)

        delayed_view.run_trie_ops_process(
            self, 'build_entity',
            base_table=self.ctx[DelayedViewEntityBaseYtTablePath.name],
            trie_path=delayed_view_entity_base_trie_resource.path
        )

        self.mark_resource_ready(delayed_view_entity_base_trie_resource.id)

    def __create_empty_trie_resource_stage(self):
        entity_trie_resource = create_trie_resource(self)
        with open(entity_trie_resource.path, 'w'):
            pass
        self.mark_resource_ready(entity_trie_resource.id)

    def on_execute(self):
        if self.ctx[EmptyEntityBaseTrie.name]:
            stage_funcs = [self.__create_empty_trie_resource_stage]
        else:
            stage_funcs = [
                self.__build_base_on_yt_stage,
                self.__create_ya_make_trie_ops_subtask_stage,
                self.__save_ya_make_trie_ops_subtask_result_stage,
                self.__build_trie_stage]

        delayed_view.process_stages(self, stage_funcs)


__Task__ = BuildDelayedViewEntityBaseTrie
