# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxBoolParameter, SandboxStringParameter


class EntityMainBaseYtTablePath(SandboxStringParameter):
    name = 'entity_main_base_yt_table_path'
    description = 'YT table path to entity main base'
    required = True


class EntityDeltaBaseYtTablePath(SandboxStringParameter):
    description = 'YT table path to entity delta base'
    name = 'entity_delta_base_yt_table_path'
    required = True


class DelayedViewEntityBaseYtTablePath(SandboxStringParameter):
    description = 'YT table path to result delayed view entity base'
    name = 'delayed_view_entity_base_yt_table_path'
    required = True


class UseExistingEntityBaseYtTable(SandboxBoolParameter):
    description = 'Flag to use entity base yt table without building if exists'
    default_value = False
    name = 'use_existing_entity_base_yt_table'
    required = True


class EmptyEntityBaseTrie(SandboxBoolParameter):
    description = 'Should release empty entity base trie instead of real one'
    default_value = False
    name = 'empty_entity_base_trie'
    required = True


def get_params():
    return [
        EntityMainBaseYtTablePath, EntityDeltaBaseYtTablePath,
        DelayedViewEntityBaseYtTablePath, UseExistingEntityBaseYtTable,
        EmptyEntityBaseTrie
    ]
