# -*- coding: utf-8 -*-

from .parameters import DelayedViewSerialBaseYtTablePath
from .parameters import EmptySerialBaseTrie
from .parameters import get_params as get_specific_params
from sandbox.projects import resource_types
import sandbox.projects.video.quality.delayed_view as delayed_view
import sandbox.sandboxsdk.task as sdk_task


__TRIE_FILE_NAME = 'delayed_view_serial_base_trie'


def create_trie_resource(task):
    return task.create_resource(description='delayed view serial base trie',
                                resource_path=__TRIE_FILE_NAME,
                                resource_type=resource_types.DELAYED_VIEW_SERIAL_BASE_TRIE,
                                attributes={'ttl': 'inf'})


class BuildDelayedViewSerialBaseTrie(sdk_task.SandboxTask):
    '''Build serial base trie for delayed view in video-search'''

    type = 'BUILD_DELAYED_VIEW_SERIAL_BASE_TRIE'

    input_parameters = delayed_view.get_common_params() + get_specific_params()

    DELAYED_VIEW_SERIAL_BASE_TRIE_PATH = 'delayed_view_serial_base_trie_path'

    def __create_ya_make_trie_ops_subtask_stage(self):
        delayed_view.create_ya_make_trie_ops_subtask(self)

    def __save_ya_make_trie_ops_subtask_result_stage(self):
        delayed_view.save_ya_make_trie_ops_subtask_result(self)

    def __build_trie_stage(self):
        delayed_view_serial_base_trie_resource = create_trie_resource(self)

        delayed_view.run_trie_ops_process(self, 'build_serial',
                                          base_table=self.ctx[DelayedViewSerialBaseYtTablePath.name],
                                          trie_path=delayed_view_serial_base_trie_resource.path)

        self.mark_resource_ready(delayed_view_serial_base_trie_resource.id)

    def __create_empty_trie_resource_stage(self):
        serial_trie_resource = create_trie_resource(self)
        with open(serial_trie_resource.path, 'w'):
            pass
        self.mark_resource_ready(serial_trie_resource.id)

    def on_execute(self):
        if self.ctx[EmptySerialBaseTrie.name]:
            stage_funcs = [self.__create_empty_trie_resource_stage]
        else:
            stage_funcs = [
                self.__create_ya_make_trie_ops_subtask_stage,
                self.__save_ya_make_trie_ops_subtask_result_stage,
                self.__build_trie_stage]

        delayed_view.process_stages(self, stage_funcs)


__Task__ = BuildDelayedViewSerialBaseTrie
