# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.parameters import SandboxBoolParameter, SandboxStringParameter


class DelayedViewSerialBaseYtTablePath(SandboxStringParameter):
    description = 'YT table path to serial base'
    default_value = '//home/videoquality/series/exports/series_data_for_video_delayed_view'
    name = 'delayed_view_serial_base_yt_table_path'
    required = True


class EmptySerialBaseTrie(SandboxBoolParameter):
    description = 'Should release empty serial base trie instead of real one'
    default_value = False
    name = 'empty_serial_base_trie'
    required = True


def get_params():
    return [DelayedViewSerialBaseYtTablePath, EmptySerialBaseTrie]
