#!/usr/bin/env bash

set -x

ping6 -n -c1 github.com

mkdir -p "$1"
echo 'DOCKER_OPTS="$DOCKER_OPTS --ipv6 --fixed-cidr-v6=fd00:bc:1::/64 --dns=2a02:6b8:0:3400::1023 --graph='"$1"'"' | tee -a /etc/default/docker

stop docker
ip link del docker0
start docker
ip6tables -t nat -A POSTROUTING -s fd00:bc:1::/64  ! -o docker0 -j MASQUERADE
echo 1 > /proc/sys/net/ipv6/conf/all/forwarding
status docker

ifconfig

docker run --privileged -i --rm ubuntu:14.04 ifconfig eth0
docker run --privileged -i --rm ubuntu:14.04 ping github.com -c4
docker run --privileged -i --rm ubuntu:14.04 ping6 github.com -c4
