#!/usr/bin/env bash

set -x

export DEBIAN_FRONTEND=noninteractive

echo "# Path to docker root: $1"
echo "# Path to resource dir: $2"

echo 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/docker ubuntu-trusty main' | tee /etc/apt/sources.list.d/mirror_yandex_ru_mirrors_docker.list
gpg --keyserver hkp://p80.pool.sks-keyservers.net:80 --recv-key F76221572C52609D && gpg --export --armor F76221572C52609D | apt-key add -
apt-get update

apt-get install -y --force-yes linux-image-extra-$(uname -r)
apt-get install -y --force-yes aufs-tools apparmor docker-engine=1.9.*

mkdir -p "$1"
echo 'DOCKER_OPTS="$DOCKER_OPTS -D --ipv6 --fixed-cidr-v6=2001:db8:1::/64 --graph='"$1"'"' | tee -a /etc/default/docker

stop docker
ip link del docker0
start docker
ip6tables -t nat -A POSTROUTING -s 2001:db8:1::/64 ! -o docker0 -j MASQUERADE
echo 1 > /proc/sys/net/ipv6/conf/all/forwarding

docker run --privileged -i --rm ubuntu:14.04 ifconfig eth0
docker run --privileged -i --rm ubuntu:14.04 ping github.com -c4
