# TEST_RESULT

import requests
import os

from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.common.errors import TaskFailure
from sandbox.sandboxsdk.parameters import SandboxUrlParameter


class DockerfileUrl(SandboxUrlParameter):
    name = 'docker_file_url'
    description = "Dockerfile url"
    default_value = 'https://paste.yandex-team.ru/139258/text'
    required = False


class BuildDockerImageV6TestResource(SandboxTask):
    type = 'BUILD_DOCKER_IMAGE_V6_TEST_RESOURCE'
    execution_space = 1
    input_parameters = [DockerfileUrl]
    package_root = 'package_root'
    path_to_dockerfile = None

    def on_execute(self):
        os.makedirs(self.package_root)
        self.path_to_dockerfile = os.path.abspath("{}/Dockerfile".format(self.package_root))
        if self.ctx.get(DockerfileUrl.name):
            self.get_dockerfile()
        else:
            with open(os.path.join(self.package_root, 'test.txt'), 'w') as f:
                f.write('test')

        self.create_resource('Test resource', self.package_root, resource_types.TEST_RESULT)

    def get_dockerfile(self):
        try:
            r = requests.get(self.ctx[DockerfileUrl.name], verify=False, stream=True, timeout=60)
            with open(self.path_to_dockerfile, 'wb') as fd:
                for chunk in r.iter_content(1024):
                    fd.write(chunk)

        except Exception as e:
            raise TaskFailure(e)


__Task__ = BuildDockerImageV6TestResource
