#!/usr/bin/env bash

set -x

export DEBIAN_FRONTEND=noninteractive

echo "# Path to docker root: $1"
echo "# Path to resource dir: $2"

echo 'deb [arch=amd64] http://mirror.yandex.ru/mirrors/docker ubuntu-trusty main' | tee /etc/apt/sources.list.d/mirror_yandex_ru_mirrors_docker.list
gpg --keyserver hkp://p80.pool.sks-keyservers.net:80 --recv-key F76221572C52609D && gpg --export --armor F76221572C52609D | apt-key add -
apt-get update

apt-get install -y --force-yes docker-engine=1.11.* unbound-config-local64

ip -6 r s
ip a

mkdir -p "$1"
stop docker
ip link del docker0
rm -rf /var/lib/docker

echo > /etc/default/docker
echo 'DOCKER_OPTS="-D -s overlay -H unix://'"$1"'/docker.sock --iptables=false --ip-forward=false --ipv6 --dns 2a02:6b8:0:3400::1023 --dns 2a02:6b8:0:3400::5005 --fixed-cidr-v6 fd00::/8 --graph '"$1"'"' | tee -a /etc/default/docker

service docker start

ip -6 r s
ip a

ip6tables -t nat -A POSTROUTING -s fd00::/8 -j MASQUERADE
echo 2 > /proc/sys/net/ipv6/conf/eth0/accept_ra
echo 1 > /proc/sys/net/ipv6/conf/all/forwarding

ip -6 r s
ip a

docker -H unix://$1/docker.sock info
docker -H unix://$1/docker.sock run -i --rm ubuntu:14.04 ifconfig eth0
docker -H unix://$1/docker.sock run -i --rm ubuntu:14.04 ping6 github.com -c4
