# -*- coding: utf-8 -*-
import logging
import re

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common import utils
import sandbox.projects.common.constants as consts

from sandbox.sandboxsdk.svn import Arcadia


class BuildExperimentsAdminkaUtils(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build utils for Experiments Adminka
    """
    type = 'BUILD_EXPERIMENTS_ADMINKA_UTILS'

    PATH_SQUEEZER = "quality/ab_testing/scripts/adminka/adminka/src/config_lib/geojuice/squeeze_geobase.py"

    TARGET_RESOURCES = (
        (resource_types.EXPERIMENTS_ADMINKA_UTILS_GEO, 'quality/ab_testing/adminka/extract_geo_tree/extract_geo_tree'),
    )

    def arcadia_info(self):
        svn_url = self.ctx.get(consts.ARCADIA_URL_KEY)
        rev = Arcadia.get_revision(svn_url)
        branch = utils.get_short_branch_name(svn_url)
        return rev, "Experiments Adminka utils  r" + rev, branch

    def on_execute(self):
        CommonBuildTask.on_execute(self)
        self.export_scripts()

    def export_scripts(self):
        logging.info('export scripts')

        svn_url = self.ctx.get(consts.ARCADIA_URL_KEY)
        revision = Arcadia.get_revision(svn_url)

        parsed_url = Arcadia.parse_url(svn_url)
        svn_path = re.sub(r'/arcadia.*', '/arcadia/' + self.PATH_SQUEEZER, parsed_url.path, count=1)

        arcadia_path = Arcadia.replace(svn_url, path=svn_path)

        path = self.path('squeeze_geobase.py')

        Arcadia.export(arcadia_path, path)

        self.create_resource(
            description='experiments adminka squeeze_geobase.py r{0}'.format(revision),
            resource_path=path,
            resource_type=resource_types.EXPERIMENTS_ADMINKA_UTILS_SQUEEZE,
            arch='linux'
        )


__Task__ = BuildExperimentsAdminkaUtils
