# -*- coding: utf-8 -*-
from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
import sandbox.projects.common.constants as consts
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common import utils


class BuildExplogDaemon(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build balancer binary
    """
    type = 'BUILD_EXPLOG_DAEMON'

    def arcadia_info(self):
        rev = utils.svn_revision(self.ctx.get(consts.ARCADIA_URL_KEY, '')) or "UNKNOWN REVISION"
        return rev, "Explog daemon r" + rev, "trunk"

    def on_execute(self):
        CommonBuildTask.on_execute(self)

    TARGET_RESOURCES = (
        (resource_types.EXPLOG_DAEMON_EXECUTABLE, 'yweb/webdaemons/explogdaemon/explogdaemon'),
    )


__Task__ = BuildExplogDaemon
