# coding: utf-8

"""
    Build binaries for favicon.yandex.net

    Used by Nanny services:
        favicon_runtime_man
        favicon_runtime_sas
        favicon_runtime_sas_staging
        favicon_runtime_vla

        favicon_cm
        favicon_cm_staging

        favicon-dolbilo

"""

import os

from sandbox.projects.favicon import (
    FaviconCmBinaries,
    FaviconCmConfigs,
    FaviconDolbiloBinaries,
    FaviconHttpDaemon,
    FaviconMakeWadIndex,
)
from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.build.parameters as build_params


class BuildFaviconRobot(YaMakeTask):
    type = 'BUILD_FAVICON_ROBOT'

    execution_space = 20 * 1024  # Mb
    required_ram = 30 * 1024  # Mb

    TARGET_RESOURCE_TYPES = (
        FaviconCmBinaries,
        FaviconCmConfigs,
        FaviconDolbiloBinaries,
        FaviconHttpDaemon,
        FaviconMakeWadIndex,
    )

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.ArcadiaPatch,
        build_params.BuildSystem,
        build_params.BuildType,
        build_params.LTO,
        build_params.Sanitize,
    ]

    def get_targets(self):
        return ['robot/favicon']

    def get_resources(self):
        resources = {}
        for resource_type in self.TARGET_RESOURCE_TYPES:
            resource = {
                'description': resource_type.name,
                'resource_type': resource_type,
                'resource_path': os.path.basename(resource_type.arcadia_build_path),
            }
            resources[resource_type.name] = resource

        return resources

    def get_arts(self):
        return [
            {'path': resource_type.arcadia_build_path}
            for resource_type in self.TARGET_RESOURCE_TYPES
        ]


__Task__ = BuildFaviconRobot
